"use client";

import React from "react";

import { cn } from "@/lib/utils";
import { routesConfig } from "@/config/routes";
import { Logo } from "../ui/logo";
import { Link, useLocation } from "@tanstack/react-router";

export function MainNavigation({
  className,
  ...rest
}: React.HTMLAttributes<HTMLElement>) {
  const { href } = useLocation();

  
  return (
    <div className="mr-4 hidden sm:flex">
      <Logo />

      <nav
        className={cn("flex items-center gap-6 text-sm", className)}
        {...rest}
        >
        {routesConfig.navigation.map((nav) => {
          return (
            <Link
              key={nav.to}
              to={nav.to}
              className={cn(
                "text-sm",
                href === nav.to
                  ? "text-accent-foreground"
                  : "text-muted-foreground",
              )}
            >
              {nav.title}
            </Link>
          );
        })}
      </nav>
    </div>
  );
}
